$PL(68) XR SB DB NOGE ; last parameter not sure - bad quality scan


NAME BOOT LOADER LEVEL0


;***********************************************************
;***********************************************************
;**                                                       **
;**           DM5 16 BIT EXTENSION FIRMWARE               **
;**                                                       **
;**                                                       **
;**                                                       **
;**            VERSION:         1.0                       **
;**                                                       **
;**                                                       **
;**                                                       **
;**                                                       **
;**                                                       **
;**            COPYRIGHT NCR CORP. 1983                   **
;**                                                       **
;***********************************************************
;***********************************************************




DATA	SEGMENT WORD COMMON 'DATA'

		BUFFER	EQU		THIS WORD
		M		LABEL	BYTE
		
;
		ORG		0F800H
;
CURSX	DB		?							;CURSOR - X - POSITION
CURSY	DB		?							;CURSOR - Y - POSITION
;

; *** COMMAND MAIL BLOCK OF LANGUAGE AND IO BOARD ***
;     *******************************************

		ORG		0FE01H
		
SB8		DB		?							;STATUS BLOCK FROM Z80

		ORG		0FE04H
		
CB16	DB		?							;COMMAND BLOCK TO 16 BIT
SB16	DB		?							;STATUS BLOCK RETURN OF 16 BIT
MEM16	DB		?							;AVAILABLE MEMORY SIZE

DATA	ENDS


$		EJECT

PUBLIC			SWITCH,EXECUTE,SOFTWARE,SWITCH_TEST

EXTRN			MONITOR:NEAR,STARTS:NEAR,DISPL:NEAR
EXTRN			KEYINP:NEAR,L_13:NEAR,DISPLAY:NEAR


BOOTER			SEGMENT WORD COMMAND 'CODE'


ASSUME	DS:DATA,CS:BOOTER,SS:DATA,ES:DATA


%DEFINE (JUMPER)(
		DW		MONITOR
		DW		STARTS
		)
		
;*** "OUT" EQUATES
;*****************

RAMSEL	EQU		10H							;RAMS SELECT
ROMSEL	EQU		11H							;ROM SELECT
PROCCH	EQU		000H						;PROCESSOR CHANGE, COULD BE 0D0H

;*** ASCII EQUATES ***
;*********************

NEWL	EQU		88H							;NEW LINE COMMAND (CR+LF)


;*** JUMP TABLE ***
;******************

JMP		DISPLAY


;*** COMMAND PHASE VERTEILER ***
;*******************************

BEGIN:	MOV		AX,DATA
		MOV		SS,AX
		MOV		SP,AX
		MOV		DS,AX
		MOV		ES,AX
		JMP		SHORT LOOK_MAIL_BOX
		
		
COMMAND	EQU		THIS WORD
		%JUMPER
		DW		EXECUTE_SOFTWARE			;PHASE 2
		DW		LEVEL0						;PHASE 3


		
		
		
SWITCH:	OUT		ROMSEL,AL
		OUT		PROCCH,AL					;RETURN TO 8 BIT
		NOP
		
LOOK_MAIL_BOX:
		OUT		RAMSEL,AL					;ALWAYS RAM SELECTION
		MOV		AL,CB16
		AND 	AX,0FH
		CMP		AL,04
		JAE		SHORT SWITCH
		SHL		AX,1
		MOV		SI,AX
		JMP		COMMAND[SI]					;JUMP TO COMMAND
		
SWITCH_TEST:
		MOV		SB16,000H					;00=GOOD STATUS
		JMP		SWITCH
		
EXECUTE_SOFTWARE:
		XOR		AX,AX
		MOV		DS,AX
		MOV		ES,AX
		MOV		DS,AX
		MOV		SP,AX

		JMP		FAR PTR CPM(&				;JUMP TO CPM86 OPERATING SOFTWARE
		
$		EJECT
		

		
		
;***********************************************************

;				POWER UP ROUTINE

;***********************************************************


LEVEL0:
		XOR		AX,AX						;SET AX AND START ADDRESS TO 00
		MOV		SI,AX
		MOV		CX,1000H					;ROM-TEST OVER 4K
SUM1:	LODS	CS:MAIL
		ADD		AH,AL
		LOOP	SUM1
		ADD		AH,00
		JZ		SHORT RAMTST				;ROM-TEST O.K.
		
LEVEL0_FAIL:
		MOV		SB16,0FFH
		JMP		SWITCH						;LEVEL 0 FAILED
		
;*** RAM-TEST ***
;    ********

RAMTST:
		MOV		CURSY,23
		MOV		CURSX,0
		LEA		BX,MESS1					;MESSAGE MEMORY TEST OF BANK
		CALL	DISPL
		LEA		BX,MESS4
		CALL	DISPL
		
		MOV		CX,2000H/3					;WRITE A UNEVEN BYTE MUSTER IN MEMORY
		XOR		DI,DI
RAMTST1A:
		MOV		AX,55AAH
		STOSW
		MOV		AL,00
		STOSB
		LOOP	RAMTST1A
		MOV		AX,55AAH
		STOSW
		
		MOV		CX,2000H/3
		XOR		DI,DI
RAMTST1B:
		MOV		AX,55AAH
		SCASW
		JNZ		ERROR0
		MOV		AL,00
		SCASB
		JNZ		ERROR0
		LOOP	RAMTST1B
		MOV		AX,55AAH
		SCASW
		JNZ		ERROR0
		
		MOV		DX,1000H
		MOV		AX,0102h
RAMTST1:									;TEST WITH A ROTATING ONE
		XOR		DI,DI
		MOV		CX,DX
		REP		STOSW
		
		XOR		DI,DI
		MOV		CX,DX
		REPZ	SCASW
		
		JNZ		ERROR0
		ROL		AL,1
		ROL		AH,1 
		JNC		RAMTST1
		
		MOV		BH,2
		MOV		AX,0AA55H
RAMTST2:
		MOV		CX,DX
		XOR		DI,DI
		REP		STOSW						;STORE AA55
		
		XOR		DI,DI
		MOV		CX,DX
		REPZ	SCASW
		
		JNZ		ERROR0
		
		XCHG	AH,AL
		DEC		BH
		JNZ		RAMTST2
		JMP		SHORT MEM_BANK_TEST
		
		
ERROR0:	MOV		CURSX,30					;WRITE 'FATAL MEMORY ERROR'
		LEA		BX,MESS2					;AND STOP PROCESSING
		CALL	DISPL
		JMP		SHORT $


;		MEMORY EXTENSION TEST
;		=====================


MEM_BANK_TEST:
		MOV		CX,3						;SET BANK COUNTER TO MAX BANKS=256K (512K)
		CMP		SB8,09						;VERSION NUMBER > 10 ?
		JB		UNDER
		ADD		CX,4						;SET BANK COUNTER TILL 512K
UNDER:	MOV		DX,0
		MOV		BL,0						;SET BANK INDICATOR
		
NEXT_BANK:
		MOV		BP,CX						;SAVE BANK COUNTER
		ADD		DX,1000H					;SET SEGMENT FOR NEXT BANK
		MOV		DS,DX
		MOV		ES,DX
		
		MOV		AX,0AA55H
		MOV		BUFFER,AX					;TEST THE FIRST TWO BYTES OF A BANK
		CMP		AX,BUFFER					;FOR A PRESENT BANK
		JZ		L_200
		JMP		MEMORY_END
L_200:	CALL	BANK_DIS

		MOV		CX,0FFFFH/3					;WRITE AN UNEVEN PATTERN IN MEMORY
		XOR		DI,DI
		
ADDTSTA:
		MOV		AX,55AAH
		STOSW
		MOV		AL,00
		STOSB
		LOOP	ADDTSTA
		MOV		AL,55H
		STOSB
		
		MOV		CX,0FFFFH/3
		XOR		DI,DI
ADDTSTB:
		MOV		AX,55AAH
		SCASW
		JNZ		ERROR1
		MOV		AL,0
		SCASB
		JNZ		ERROR1
		LOOP	ADDTSTB
		MOV		AL,55H
		SCASB
		JNZ		ERROR1
		
		XOR		DI,DI
		MOV		SI,8000H					;COUNTER OF A ENTIRE BANK 64K
		
		MOV		AX,0102H
ROT_ONE:
		XOR		DI,DI
		MOV		CX,SI
		REP		STOSW
		XOR		DI,DI
		MOV		CX,SI
		REPZ	SCASW
		JNZ		ERROR1
		ROL		AL,1
		ROL		AH,1
		JNC		ROL_ONE
		
		MOV		BH,2						;COUNT OF BIT PATTERN
		MOV		AX,0AA55H
MEM_TEST:
		MOV		CX,SI						;SET COUNTER FOR A ENTIRE BANK = 8000 WORDS
		XOR		DI,DI
		REP		STOSW						;STORE AX INTO MEMORY
		
		XOR		DI,DI
		MOV		CX,SI
		REPZ	SCASW
		
		JNZ		ERROR1
		
		XCHG	AH,AL
		DEC		BH
		JNZ		MEM_TEST
		
GOOD_BANK:
		INC		BL							;GOOD BANK INC BANK INDICATOR
		MOV		CX,BP
		LOOP	NEXT_BANK					;ALL BANKS ?
		JMP		SHORT MEMORY_END
		
ERROR1:	XOR		AX,AX
		MOV		DS,AX
		MOV		ES,AX						;SET SEGMENT TO ZERO
		PUSH	BX
		MOV		CURSX,30
		LEA		BX,MESS3					;ERROR DETECTED WRITE FAILED TO SCREEN
		CALL	DISPL
ERR11:	CALL	KEYINP
		CMP		AL,NEWL
		JNZ		ERR11
		POP		BX
		
MEMORY_END:
		XOR		AX,AX
		MOV		DS,AX
		MOV		ES,AX						;SET SEGMENT TO ZERO
		MOV		CURSY,10
		MOV		MEM16,BL					;SET COUNT OF MEM BANKS IN MEM16
		MOV		SB16,=
		JMP		SWITCH						;JUMP TO 8 BIT
		
BANK_DIS:
		PUSH	AX
		XOR		AX,AX
		MOV		DS,AX
		MOV		ES,AX						;SET SEGMENT TO ZERO BANK
		MOV		AL,5
		MUL		BL
		PUSH	BX
		PUSH	CX
		PUSH	AX
		MOV		CURSY,23					;SET CURSOR FOR MESSAGES
		MOV		CURSX,0						
		LEA		BX,MESS1					;WRITE MEMORY TEST ON SCREEN
		CALL	DISPL
		POP		AX
		
		MOV		BX,AX
		LEA		AX,BANKS
		ADD		BX,AX
		MOV		CH,9
		CALL	L_13+10						;WRITE THE TESTED BANK TO SCREEN
		POP		CX
		POP		BX
		POP		AX
		MOV		DS,DX
		MOV		ES,DX
		RETURN
		
		
MESS1	DB		17,'TEST MEMORY BANK '
MESS2	DB		18,'FATAL MEMORY ERROR'
MESS3	DB		11,'FAILED (CR)'
MESS4	DB		8,'   0-64K'
BANKS	DB		' 64K-128K-192K-256K-320K-384K-448K-512K'



BOOTER	ENDS


SOFTWARE		SEGMENT PARA PUBLIC 'CODE'

		CPM86	EQU		THIS FAR

SOFTWARE		ENDS

		ENDS	BEGIN
		
------------------------------------------------------------		
SERIES-III 8086/8087/8088 MACRO ASSEMBLER V1.1 ASSEMBLY OF MODULE BOOTER_IO_DRIVER
OBJECT MODULE PLACED IN :F1:DM16IO.OBJECT
ASSEMBLER INVOKED BY:  A86.(& :F1:DM16IO.SRC

$PAGELENGTH(68) XREF SYMBOLS DEBUG EP NOMR

NAME BOOTER_IO_DRIVER

;***********************************************************
;***********************************************************
;**                                                       **
;**          DM5 16 BIT EXTENSION FIRMWARE                **
;**                                                       **
;**           IDENTIFIER:     AMF-DM16FI 0101-00          **
;**                                                       **
;**           VERSION:        1.0                         **
;**                                                       **
;**           DATE:           24.02.83                    **
;**                                                       **
;**           ORIG. PLANT:    NCR AUGSBURG                **
;**                                                       **
;**           COPYRIGHT NCR CORP. 1983                    **
;**                                                       **
;***********************************************************
;***********************************************************
		
DATA	SEGMENT WORD 	COMMON 'DATA'

		BUFFER	EQU		THIS WORD
		M		LABEL	BYTE
		
		ORG		0F800H
		
CURSX	DB		?							;CURSOR - X - POSITION
CURSY	DB		?							;CURSOR - Y - POSITION
		
		ORG		0F830H
		
BUFSTA	DB		?

		ORG		0F900H
		
CEADL	DB		?							;LOW BYTE OF CURSOR
CEADH	DB		?							;HIGH BYTE OF CURSOR
CDAD	DB		?							;POS OF PIXEL
SP1		DW		?							;START OF PAGE 1
LP11	DB		?							;LENGTH OF PAGE 1 LOW
LP12	DB		?							;LENGTH OF PAGE 1 HIGH
SP2		DW		?							;START OF PAGE 2
LP21	DB		?							;LENGTH OF PAGE 2 LOW
LP22	DB		?							;LENGTH OF PAGE 2 HIGH
INVFLG	DB		?

DATA	ENDS

$ EJECT

PUBLIC			KEYINP,KYLOOK,MODCRT,SETCU,CALCHR,DISPL,L_13,DISPL1
PUBLIC			DISPLAY

BOOTER			SEGMENT BYTE COMMON 'CODE'


		ASSUME	DS:DATA,CS:BOOTER,SS:DATA,ES:DATA
		
		ORG		250H

		
;*** "OUT" EQUATES ***		
;*********************
		
RAMSEL	EQU		10H							;RAMS SELECT
ROMSEL	EQU		11H							;ROM SELECT



;***************************************
;
;  DRIVER FOR KEYBOARD-CONTOLLER 8741		
;		
;***************************************


; *** "IN/OUT" EQUATES ***
;     *****************

KEYDAT	EQU		40H							;READ KEYBOARD DATA
KEYSTA	EQU     41H							;READ     "    STATUS


KEYINP:	IN		AL,KEYSTA
		RCR		AL,1
		JNC		KEYINP
		IN		AL,KEYDAT					;READ KEYBOARD CHARACTER
		RET
		
KYLOOK:	IN		AL,KEYSTA
		AND		AL,1 
		JNZ		SHORT L_1
		RET
L_1:	IN		AL,KEYDAT
		RET
		

;***************************************
;
;          CRT-ROUTINES		
;		
;***************************************		
		
		
		
		
;*** CONTROL CHARACTER EQUATES ***
;    *************************

NOMOV	EQU		00H
PROMPT	EQU		2AH
SPACE	EQU		20H
NEWL	EQU		88H
HOME	EQU		01H
SCRER	EQU		0CH
RUBOUT	EQU		8BH



;***************************************
;
;          CRT-ROUTINES		
;		
;***************************************


CHARA	EQU		80						;80 CHARACTERS/LINE


;		*** GDC PORT EQUATES ***
;			****************
			
GDCCOM	EQU		0A1H					;WRITE COMMAND
GDCSTA	EQU		0A0H					;READ STATUS
GDCPAR	EQU		0A0H

;		*** GDC STATUS EQUATES ***
;			******************

FIFULL	EQU		02H						;FIFO IS FULL

;		*** GDC COMMAND EQUATES ***
;			*******************

START	EQU		6BH						;START DISPLAY/END IDLE-MODE
CURS	EQU		49H						;SPECIFY CURSOR-POSITION
MASK_	EQU		4AH						;LOAD MASK-REGISTER
FIGS	EQU		4CH						;SPECIFY FIGURE DRAWING-PARAMETER
PRAM	EQU		70H						;LOAD PARAMETER-RAM
WDAT	EQU		20H						;WRITE DATA INTO DISPLAY MEMORY
										;(COMMAND+TYPE+MODE)
TYWORD	EQU		00H						;DATA TRANSFER BYTES
										;MODE OF RMW MEMORY CYCLE
MOREPL	EQU		00H						;REPLACE WITH PATTERN




MODCRT:	PUSH	BP
		PUSH	SI
		PUSH	DI
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSHF
		PUSH	AX						;SAVE ASCII-CHARACTER
		
;*** CHECK IF ANY CONTROL CHARACTER ***
;	 ******************************

		TEST	AL,0F0H
		JZ		SHORT SETCHA
		CMP		AL,NOMOV
		JE		GETRE					;NO CURSOR MOVE
		CMP		AL,NEWL
		JE		SHORT CARRET			;CARRIAGE RETURN
		CMP		AL,HOME
		JE		SHORT CHP				;HOME POSITION
		CMP		AL,SCRER
		JE		SHORT SCERA				;SCREEN ERASE
		JMP		SHORT SETCHA			;SET CHARACTER INTO CRT-BUFFER DEPENDING
		
CARRET:	MOV		CURSX,=
		MOV		AL,CURSY
		INC		AL
		CMP		AL,25
		JNE		CAR1
		PUSH	AX
		CALL	SCROLM
		POP		AX,
		DEC		AL
CAR1:	MOV		CURSY,AL
		JMP		SHORT GETRE
		
;*** CURSOR HOME POSITION ***
;	********************
			
CHP:	XOR		AX,AX
		MOV		WORD PTR CURSX,AX
		JMP		SHORT GETRE

;*** SCREEN ERASE ***
;	 ************
SCERA:	CALL 	MCLRSCR
		JMP		CHP
		
;*** SET CHARACTER ***
;	 *************
SETCHA:	MOV		AX,WORD PTR CURSX
		CMP		AL,80						;END OF LINE?
		JNZ		SHORT CHA1
		XOR		AL,AL
		INC		AH							;INCREMENT CURSY
CHA1:	CMP		AH,25						
		JNZ		SHORT CHA2					;END OF SCREEN?
		PUSH	AX							;AH = Y POSITION
		CALL	SCROLM						;AL = X POSITION
		POP		AX
		DEC		AH
CHA2:	MOV		CX,AX						;<CX = Y AND X POSITION
		INC		AL							;NEXT CURS POSITION
		MOV		WORD PTR CURSX,AX
		POP		AX							;RESTORE ASCII CHARACTER
		PUSH	AX
		CALL	WRMCHR						;(A) = ASCII CHARACTER
											;(B)=Y-POS,(C) = X-POS
GETRE:	POP		AX
		POPF
		POP		DX
		POP		CX
		POP		BX
		POP		DI
		POP		SI
		POP		BP
		RET
		

;***************************************
;
;          G D C  DRIVER ROUTINES		
;		
;***************************************		
		

;ENTRY:	(AL) = ASCII CHARACTER
;		(CH) = Y-POSITION
;		(CL) = X-POSITION
		
WRMCHR:	PUSH	BX
		PUSH	DX
		PUSH	CX
		PUSH	AX
		
		CALL 	CALCHR							;CALCULATE CHARACTER-POS
		CALL	SETCU
		CALL	SETCCA							;SEND CHARACTER
		MOV		AL,WDAT+TYWORD+MOREPL
		CALL	OUTCMD
		POP		AX								;(A)=ASCII-CHARACTER
		CALL	OUTPAR
		MOV		AL,INVFLG						;FETCH ATTRIBUTE
		CALL	OUTPAR
		POP		CX
		POP		DX
		POP		BX
		RET
		
		
SETCCA:	CALL	SETMSK
		MOV		AL,FIGS
		CALL	OUTCMD
		MOV		AL,2
		CALL	OUTPAR
		XOR		AL,AL
		CALL	OUTPAR
		RET
		
CALCHR:	
		TEST	SP,0FFFFH
		JNZ		SHORT CALCH1
		MOV		AL,80							;Y*80 + X = (CEADL)
		MUL		CH
CALCH2:	MOV		CH,0-64K
		ADD		AX,CX
		MOV		WORD PTR CEADL,AX
		RET
		
CALCH1:											;(CH)=Y-POS
		MOV		AL,80
		MUL		CH								;Y * 80
		ADD		AX,SP1							;(SP1) + (Y*80)=AX
		MOV		DX,25*80
		CMP		AX,DX
		JB		CALCH2
		SUB		AX,DX
		JMP		CALCH2
		


;		***	CLEAR SCREEN ***
;			************


MCLRSCR: CALL	SETCR							;SET CURSOR IN HOME-POS.
		CALL	CLRL							;CLEAR SCREEN
		CALL	INIT1A
		CALL	SCROL1							;SET PARTITION
		RET
		
		
CLRL:	MOV		AL,WDAT+TYWORD+MOREPL
		CALL	OUTCMD
		MOV		AL,' '							;SPACE-WRITE
		CALL	OUTPAR
		XOR		AL,AL
		CALL	OUTPAR							;CLEAR ATTRIBUTE
		RET
		

		
;		*** SCROLL SCREEN ***
;			*************


SCROLM:	MOV		BX,SP1
		MOV		WORD PTR CEADL,BX
		CALL	SETCU							;SET CURSOR
		CALL	SETMSK							;SET WORD-TRANSFER
		
		MOV		AL,FIGS							;SET LENGTH (80-CHAR)
		CALL	OUTCMD							;FOR DELETE 1 LINE
		MOV		AL,2
		CALL	OUTPAR
		MOV		AL,80-1
		CALL	OUTPAR
		XOR		AL,AL
		CALL	OUTPAR
		
		CALL	CLRL							;CLEAR LAST LINE
		MOV		BX,WORD PTR CEADL				;SET CURSOR
		CALL	SETCU
		
		ADD		SP1,80							;POINTER + 80-CHAR:
		
		MOV		AL,LP12
		DEC		AL								;LENGTH - 1
		JNZ		SHORT L_31
		JMP		INI10
L_31:
		MOV		LP12,AL
		
		INC		LP22							;LENGTH + 10
		JMP		SHORT SCROL1
		
		
		
		
		
INIT1A	XOR		AX,AX
		MOV		SP1,AX
		MOV		SP2,AX
		MOV		LP22,AL
		MOV		LP12,25
		RET
		
SETCR:	CALL	CUHOM1							;WHOLE GRAPHIC MODE
		CALL	SETMSK
		MOV		AL,FIGS							;SET DIRECTION AND NUMBER OF WORDS
		CALL	OUTCMD
		MOV		AL,2							;DIR = 2
		CALL	OUTPAR
		MOV		AL,0FFH							;LENGTH 16K WORD
		CALL	OUTPAR
		MOV		AL,3FH							;HIGH BYTE
		CALL	OUTPAR
		RET
		
SETMSK:	MOV		AL,MASK_						;SET MASK TO STORED VALUES
		CALL	OUTCMD
		MOV		AL,0FFH							;LOAD LOW BYTE
		CALL	OUTPAR
		CALL	OUTPAR
		RET
		
CUHOM1:	MOV		AL,CURS
		CALL	OUTCMD							;CURSOR HOME
		XOR		AL,AL
		CALL	OUTPAR
		CALL	OUTPAR
		CALL	OUTPAR
		RET
		
SETCU:	MOV		AL,CURS
		CALL	OUTCMD							;SET CURSOR
		MOV		AL,CEADL						;LOW BYTE OF CURSOR
		CALL	OUTPAR
		MOV		AL,CEADH						;HIGH BYTE OF CURSOR
		CALL	OUTPAR
		MOV		AL,CDAD							;POSITION OF PIXEL
		CALL	OUTPAR
		RET
		
SCROL1:	MOV		AL,PRAM+0-64K
		CALL	OUTCMD
		MOV		CX,8							;SET START AND LENGTH OF
		LEA		BX,SP1							;PAGE 1 AND PAGE 2000H/3
		CALL	SENPAR
		RET
		
INI10:	XOR		AX,AX
		MOV		SP1,AX
		MOV		SP2,AX							;START OF PAGE 1 = 0
		MOV		LP22,AL							;LENGTH OF PAGE 2 = 0
		MOV		LP12,25							;LENGTH OF PAGE 1 = 25
		JMP		SCROL1
		
		
;*** SUBROUTINES OF GDC ***
;	 ******************

OUTCMD:	CALL	FIFRDY							;PUT A COMMAND IN FIFO
		OUT		GDCCOM,AL
		RET
		
OUTPAR:	CALL	FIFRDY							;PUT A PARAMETER TO FIFO
		OUT		GDCPAR,AL
		RET
		
FIFRDY:	PUSHF
		PUSH	AX
		
FIF010:	IN		AL,GDCSTA						;READ GDC-STATUS
		AND		AL,FIFULL
		JNZ		FIF010							;JUMP IF FIFO FULL
		POP		AX
		POPF
		RET

		
SENPAR:	MOV		AL,[BX]							;LOAD PARAMETER
		CALL	OUTPAR							;OUTPUT PARAMETER
		INC		BX
		LOOP	SENPAR							;LOOP UNTIL END OF PARAMETER-LIST
		RET
		
		
;***************************************
;
;         SUBROUTINES		
;		
;***************************************
		

;*** DISPLAY ROUTINE ***
;	 ***************

DISPL:	MOV		CH,CS:[BX]
L_13:	INC		BX
		MOV		AL,CS:[BX]
		CALL	MODCRT
		DEC		CH
		JNZ		L_13
		INC		BX
		RET
		
DISPL1:	MOV		AL,[BX]
		CALL	MODCRT
		INC		BX
		LOOP	DISPL1
		RET
		
DISPLAY PROC FAR

		MOV		CL[BX]
		XOR		CH,CH
DISP_N:	INC		BX
		MOV		AL,[BX]
		CALL	MODCRT
		LOOP	DISP_N
		RET
		
DISPLAY	ENDP
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
